
#Modele lineaire 79

setwd("C:/Users/user/Desktop/sae stats")
test <- read.csv2("test.csv")
train <- read.csv2("train.csv")

# enlever le premier et dernier décile des données de train
train <- train[train$Valeur.fonciere > quantile(train$Valeur.fonciere, 0.1) &
                 train$Valeur.fonciere < quantile(train$Valeur.fonciere, 0.9), ]

dep <- train$Code.departement == '79'

trainlineaire <- data.frame(train$Surface.reelle.bati[dep], train$Valeur.fonciere[dep])
names(trainlineaire)<-c('Surface.reelle.bati','Valeur.fonciere')


# Variances et covariance
varx <- mean(trainlineaire$Surface.reelle.bati^2) - mean(trainlineaire$Surface.reelle.bati)^2
vary <- mean(trainlineaire$Valeur.fonciere^2) - mean(trainlineaire$Valeur.fonciere)^2
covxy <- mean(trainlineaire$Surface.reelle.bati*trainlineaire$Valeur.fonciere) - mean(trainlineaire$Surface.reelle.bati)*mean(trainlineaire$Valeur.fonciere)

# Coefficient de corr?lation
a <- covxy / varx
b <- mean(trainlineaire$Valeur.fonciere) - a*mean(trainlineaire$Surface.reelle.bati)
r <- covxy / (sqrt(varx*vary))

# Performances prédites
BrainPredites <- a * trainlineaire$Surface.reelle.bati + b

# Résidus et SCR
Residus <- trainlineaire$Valeur.fonciere - BrainPredites
SCR <- sum(Residus^2)
SCR

# Valeurs prédites
y_pred <- a * test$Surface.reelle.bati + b
y_pred

# Ajoute d'une colonne 'Valeur.fonciere_predite' au dataframe test
test$Valeur.fonciere_predite <- y_pred

test <- test[, c("id", "Valeur.fonciere_predite")]

# Enregistrement du dataframe  dans un fichier CSV "test_pred.csv"
write.csv2(test, file = "prediction.csv", row.names = FALSE)

